/*
 * Decompiled with CFR 0.152.
 */
package test.endtoend;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.Util;
import org.das2.client.DasServer;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.stream.StreamDescriptor;

public class Test501 {
    private static final int READ_SIZE_LIMIT_DAYS = 400;
    private static final int testid = 501;

    static void flatten(TreeModel tm, String root, Object node, List<String> result) {
        for (int i = 0; i < tm.getChildCount(node); ++i) {
            Object child = tm.getChild(node, i);
            if (tm.isLeaf(child)) {
                String ss = (String)((DefaultMutableTreeNode)child).getUserObject();
                result.add(root + "/" + ss);
                continue;
            }
            String us = (String)((DefaultMutableTreeNode)child).getUserObject();
            Test501.flatten(tm, root + "/" + us, child, result);
        }
    }

    private static String do1(String uri, int iid, boolean doTest) throws Exception {
        String name;
        System.err.printf("uri: %s\n", uri);
        long t0 = System.currentTimeMillis();
        QDataSet ds = Util.getDataSet((String)uri);
        double t = (double)(System.currentTimeMillis() - t0) / 1000.0;
        MutablePropertyDataSet hist = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)ds);
        hist.putProperty("TITLE", (Object)uri);
        String label = String.format("test%03d_%03d", 501, iid);
        hist.putProperty("LABEL", (Object)label);
        ScriptContext.formatDataSet((QDataSet)hist, label + ".qds");
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            MutablePropertyDataSet hist2 = (MutablePropertyDataSet)Ops.autoHistogram((QDataSet)dep0);
            ScriptContext.formatDataSet((QDataSet)hist2, label + ".dep0.qds");
        } else {
            PrintWriter pw = new PrintWriter(label + ".dep0.qds");
            pw.println("no dep0");
            pw.close();
        }
        ScriptContext.plot(ds);
        ScriptContext.setCanvasSize(750, 300);
        int i = uri.lastIndexOf("/");
        ScriptContext.getApplicationModel().waitUntilIdle();
        String fileUri = uri.substring(i + 1);
        if (!ScriptContext.getDocumentModel().getPlotElements(0).getComponent().equals("")) {
            String dsstr = String.valueOf(ScriptContext.getDocumentModel().getDataSourceFilters(0).getController().getDataSet());
            fileUri = fileUri + " " + dsstr + " " + ScriptContext.getDocumentModel().getPlotElements(0).getComponent();
        }
        String result = null;
        ScriptContext.setTitle(fileUri);
        if (doTest) {
            int h = uri.hashCode();
            if (h == Integer.MIN_VALUE) {
                h = Integer.MAX_VALUE;
            }
            if (h < 0) {
                h = -1 * h;
            }
            String id = String.format("%016d", h);
            result = name = String.format("test%03d_%s.png", 501, id);
        } else {
            name = String.format("ex_test%03d_%03d.png", 501, iid);
            result = null;
        }
        ScriptContext.writeToPng(name);
        System.err.printf("wrote to file: %s\n", name);
        System.err.printf("Read in %9.3f seconds (%s): %s\n", t, label, uri);
        return result;
    }

    public static void main(String[] args) throws Exception {
        ScriptContext.getDocumentModel().getOptions().setAutolayout(false);
        ScriptContext.getDocumentModel().getCanvases(0).getMarginColumn().setRight("100%-10em");
        int iid = 0;
        DasServer[] dsss = new DasServer[]{DasServer.create((URL)new URL("http://www-pw.physics.uiowa.edu/das/das2Server")), DasServer.create((URL)new URL("http://emfisis.physics.uiowa.edu/das/das2Server"))};
        LinkedHashMap<Integer, String> failures = new LinkedHashMap<Integer, String>();
        String[] serverSkip = new String[]{"http://www-pw.physics.uiowa.edu/das/das2Server 003,005,006,007,008,009"};
        for (int idsss = 0; idsss < dsss.length; ++idsss) {
            DasServer dss = dsss[idsss];
            System.err.println("## Testing server: " + dss);
            TreeModel tm = dss.getDataSetListWithDiscovery();
            ArrayList<String> ids = new ArrayList<String>();
            Test501.flatten(tm, "", tm.getRoot(), ids);
            ArrayList<Object> skip = dss == dsss[0] ? new ArrayList<Integer>(Arrays.asList(3, 4, 5, 6, 7, 18)) : new ArrayList();
            for (String server : serverSkip) {
                String[] sskip;
                String[] ss = server.split(" ", 2);
                String host = ss[0];
                if (!dsss[idsss].toString().contains(host)) continue;
                for (String ssi : sskip = ss[1].split(",")) {
                    skip.add(Integer.parseInt(ssi));
                }
            }
            int count = 0;
            for (String id : ids) {
                if (id.contains("/testing/")) {
                    System.err.println("skipping /testing/: " + id);
                    continue;
                }
                if (id.contains("/test/")) {
                    System.err.println("skipping /test/: " + id);
                    continue;
                }
                ++count;
            }
            System.err.println("Skipping the tests: " + skip);
            int iis = 0;
            for (String id : ids) {
                int ipipe = id.indexOf(124);
                if (ipipe > -1) {
                    id = id.substring(0, ipipe).trim();
                }
                System.err.println(String.format("==== test %03d of %d (%03d) ========================================================", iis, count, iid));
                if (id.contains("/testing/")) {
                    System.err.println("ids containing /testing/ are automatically skipped: " + id);
                    ++iis;
                    continue;
                }
                if (id.contains("/test/")) {
                    System.err.println("ids containing /test/ are automatically skipped: " + id);
                    ++iis;
                    continue;
                }
                if (id.contains("freq/f_")) {
                    System.err.println("Kludge for skipping Jeremy's FCE freq stuff, which is redundant and slow " + id);
                    ++iis;
                    continue;
                }
                if (skip.contains(iis)) {
                    ++iis;
                    System.err.println("test marked for skipping in Test501.java: " + id);
                    continue;
                }
                String uri = "";
                try {
                    DatumRange tr;
                    System.err.println(String.format("uri: vap+das2server:%s?dataset=%s", dss.getURL(), id));
                    StreamDescriptor dsdf = dss.getStreamDescriptor(dss.getURL(id));
                    String exampleRange = (String)dsdf.getProperty("exampleRange");
                    if (exampleRange == null) {
                        ++iis;
                        System.err.println("test that should have had exampleRange did not: " + id);
                        continue;
                    }
                    int ic = exampleRange.indexOf(124);
                    if (ic > -1) {
                        exampleRange = exampleRange.substring(0, ic);
                    }
                    if ((tr = DatumRangeUtil.parseTimeRangeValid((String)exampleRange)).width().gt(Units.days.createDatum(400))) {
                        throw new IllegalArgumentException("exampleRange parameter is too large, limit is 400 days");
                    }
                    uri = "vap+das2server:" + dss.getURL() + "?dataset=" + id + "&start_time=" + tr.min() + "&end_time=" + tr.max();
                    System.err.println("uri: " + uri);
                    Test501.do1(uri, iid, false);
                    String testRange = (String)dsdf.getProperty("testRange");
                    if (testRange != null) {
                        System.err.println("testRange parameter found: " + testRange);
                        ic = testRange.indexOf(124);
                        if (ic > -1) {
                            testRange = testRange.substring(0, ic);
                        }
                        tr = DatumRangeUtil.parseTimeRangeValid((String)testRange);
                        uri = "vap+das2server:" + dss.getURL() + "?dataset=" + id + "&start_time=" + tr.min() + "&end_time=" + tr.max();
                        System.err.println("id: " + id);
                        System.err.println("uri: " + uri);
                        String result = Test501.do1(uri, iid, true);
                        File f = new File("map_" + result + "__" + iid);
                        FileOutputStream fi = new FileOutputStream(f);
                        fi.write(uri.getBytes());
                        fi.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    failures.put(iid, uri);
                }
                ++iis;
                ++iid;
            }
        }
        System.err.println("DONE...");
        System.err.println("======= Report Summary =======");
        if (failures.size() > 0) {
            System.err.println(String.format("found %d failures:", failures.size()));
            Iterator iterator = failures.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                System.err.println(String.format("(%03d): %s", i, failures.get(i)));
            }
            System.exit(1);
        } else {
            System.err.println("no failures, happy day.");
            System.exit(0);
        }
    }
}

